/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.mixin.client;

import java.awt.Point;
import java.util.Arrays;
import java.util.Comparator;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockAndTintGetter;
import org.betterx.bclib.util.MHelper;
import org.betterx.betterend.client.ClientOptions;
import org.betterx.betterend.registry.EndBlocks;
import org.betterx.ui.ColorUtil;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={BiomeColors.class})
public class BiomeColorsMixin {
    private static final int POISON_COLOR = ColorUtil.color((int)92, (int)160, (int)78);
    private static final int STREAM_COLOR = ColorUtil.color((int)105, (int)213, (int)244);
    private static final Point[] OFFSETS;

    @Inject(method={"getAverageWaterColor"}, at={@At(value="RETURN")}, cancellable=true)
    private static void be_getWaterColor(BlockAndTintGetter world, BlockPos pos, CallbackInfoReturnable<Integer> info) {
        if (ClientOptions.useSulfurWaterColor()) {
            BlockPos.MutableBlockPos mut = new BlockPos.MutableBlockPos();
            mut.m_142448_(pos.m_123342_());
            for (int i = 0; i < OFFSETS.length; ++i) {
                mut.m_142451_(pos.m_123341_() + BiomeColorsMixin.OFFSETS[i].x);
                mut.m_142443_(pos.m_123343_() + BiomeColorsMixin.OFFSETS[i].y);
                if (!world.m_8055_((BlockPos)mut).m_60713_(EndBlocks.BRIMSTONE)) continue;
                info.setReturnValue((Object)(i < 4 ? POISON_COLOR : STREAM_COLOR));
                return;
            }
        }
    }

    static {
        int index = 0;
        OFFSETS = new Point[20];
        for (int x = -2; x < 3; ++x) {
            for (int z = -2; z < 3; ++z) {
                if (x == 0 && z == 0 || Math.abs(x) == 2 && Math.abs(z) == 2) continue;
                BiomeColorsMixin.OFFSETS[index++] = new Point(x, z);
            }
        }
        Arrays.sort(OFFSETS, Comparator.comparingInt(pos -> MHelper.sqr((int)pos.x) + MHelper.sqr((int)pos.y)));
    }
}

